document.addEventListener("DOMContentLoaded", () => {
  fetch("js/testimonios.json")
    .then(res => res.json())
    .then(testimonios => {
      const container = document.getElementById("lista-testimonios");
      testimonios.forEach(t => {
        const div = document.createElement("div");
        div.className = "testimonio";
        div.innerHTML = `
          <blockquote>"${t.message}"</blockquote>
          <p><strong>${t.nombre}</strong> - <em>${t.fecha}</em></p>
        `;
        container.appendChild(div);
      });
    });
});