document.addEventListener("DOMContentLoaded", () => {
  fetch("js/posts.json")
    .then(res => res.json())
    .then(posts => {
      const container = document.getElementById("lista-publicaciones");
      const buscador = document.getElementById("buscador");
      const botones = document.querySelectorAll("#filtros button");

      function render(filtered) {
        container.innerHTML = "";
        filtered.forEach(post => {
          const div = document.createElement("article");
          div.innerHTML = `<h3>${post.title}</h3><p><em>${post.date} - ${post.category}</em></p><p>${post.excerpt}</p>`;
          container.appendChild(div);
        });
      }

      function filterPosts(cat, query) {
        return posts.filter(p =>
          (cat === "Todos" || p.category === cat) &&
          (p.title.toLowerCase().includes(query.toLowerCase()) || p.excerpt.toLowerCase().includes(query.toLowerCase()))
        );
      }

      let categoria = "Todos";
      let texto = "";
      render(filterPosts(categoria, texto));

      buscador.addEventListener("input", e => {
        texto = e.target.value;
        render(filterPosts(categoria, texto));
      });

      botones.forEach(btn => {
        btn.addEventListener("click", () => {
          categoria = btn.dataset.cat;
          render(filterPosts(categoria, texto));
        });
      });
    });
});